﻿-- the full database schema
CREATE TABLE IF NOT EXISTS meta (
    key TEXT NOT NULL PRIMARY KEY,
    value TEXT
);

CREATE TABLE IF NOT EXISTS beams (
    uid TEXT NOT NULL PRIMARY KEY,
    manufacturer TEXT NOT NULL,
    slotsize TEXT NOT NULL,
    gridsize TEXT NOT NULL,
    name TEXT NOT NULL,
    sectionwidth REAL NOT NULL,
    sectionheight REAL NOT NULL,
    filename TEXT NOT NULL,
    UNIQUE (manufacturer, slotsize, gridsize, name) ON CONFLICT ROLLBACK
);

CREATE TABLE IF NOT EXISTS beamproperties (
    uid TEXT NOT NULL REFERENCES beams (uid) ON UPDATE CASCADE ON DELETE CASCADE,
    key TEXT NOT NULL,
    value TEXT NOT NULL,
    UNIQUE (uid, key) ON CONFLICT ROLLBACK
);

CREATE TABLE IF NOT EXISTS beamslots (
    uid TEXT NOT NULL REFERENCES beams (uid) ON UPDATE CASCADE ON DELETE CASCADE,
    no TEXT NOT NULL,
    pointx REAL NOT NULL,
    pointy REAL NOT NULL,
    dirx REAL NOT NULL,
    diry REAL NOT NULL,
    blocked INTEGER NOT NULL,
    UNIQUE (uid, no) ON CONFLICT ROLLBACK
);

CREATE TABLE IF NOT EXISTS beamchannels (
    uid TEXT NOT NULL REFERENCES beams (uid) ON UPDATE CASCADE ON DELETE CASCADE,
    no TEXT NOT NULL,
    pointx REAL NOT NULL,
    pointy REAL NOT NULL,
    UNIQUE (uid, no) ON CONFLICT ROLLBACK
);

-- set the database version
INSERT INTO meta VALUES ('AluBeamsVersion', '1');
