﻿CREATE TABLE IF NOT EXISTS tconnections (
	uid	TEXT NOT NULL REFERENCES connections (uid) ON UPDATE CASCADE ON DELETE CASCADE,
	endbeammanufacturer TEXT NOT NULL,
	endbeamslotsize TEXT NOT NULL,
	endbeamgridsize TEXT, -- NOT NULL omitted for backwards compatibility
	endbeamname TEXT, -- NOT NULL omitted for backwards compatibility
	crossbeammanufacturer TEXT NOT NULL,
	crossbeamslotsize TEXT NOT NULL,
	crossbeamgridsize TEXT, -- NOT NULL omitted for backwards compatibility
	crossbeamname TEXT, -- NOT NULL omitted for backwards compatibility
	endisslot INTEGER NOT NULL,
	crossisslot INTEGER NOT NULL,
	angle REAL, -- NOT NULL omitted for backwards compatibility
	UNIQUE (uid)
);

INSERT INTO tconnections SELECT
uid,
(SELECT value FROM connectiontextdata WHERE connections.uid = uid AND key = 'EndBeamManufacturer'),
(SELECT value FROM connectiontextdata WHERE connections.uid = uid AND key = 'EndBeamSeries'),
NULL,
NULL,
(SELECT value FROM connectiontextdata WHERE connections.uid = uid AND key = 'CrossBeamManufacturer'),
(SELECT value FROM connectiontextdata WHERE connections.uid = uid AND key = 'CrossBeamSeries'),
NULL,
NULL,
(SELECT value FROM connectionintegerdata WHERE connections.uid = uid AND key = 'EndIsSlot'),
(SELECT value FROM connectionintegerdata WHERE connections.uid = uid AND key = 'CrossIsSlot'),
NULL
FROM connections
WHERE type = 'TConnection';

CREATE TABLE IF NOT EXISTS feet (
	uid TEXT NOT NULL REFERENCES connections (uid) ON UPDATE CASCADE ON DELETE CASCADE,
	beammanufacturer TEXT NOT NULL,
	beamslotsize TEXT NOT NULL,
	beamgridsize TEXT, -- NOT NULL omitted for backwards compatibility
	beamname TEXT, -- NOT NULL omitted for backwards compatibility
	UNIQUE (uid)
);

INSERT INTO feet SELECT
uid,
(SELECT value FROM connectiontextdata WHERE connections.uid = uid AND key = 'BeamManufacturer'),
(SELECT value FROM connectiontextdata WHERE connections.uid = uid AND key = 'BeamSeries'),
NULL,
NULL
FROM connections
WHERE type = 'Foot';

DROP TABLE connectiontextdata;

DROP TABLE connectionrealdata;

DROP TABLE connectionintegerdata;

INSERT OR REPLACE INTO meta VALUES ('AluConnectionsVersion', '2');
